block IO {
	//	void newline() {
	//		putChar( '\n' );
	//		}
	public block newline uses proc, CALLSYS {
		code {
		public enter:
			lda		$sp,	-sav0($sp);
			stq		$ra,	savRet($sp);
		body:
			mov		'\n',	$a0;
			bsr		Sys.putChar.enter;
		return:
			ldq		$ra,	savRet($sp);
			lda		$sp,	+sav0($sp);
			ret;
			}
		}
	
	//	void print( char *s ) {
	//		while ( *s != 0 ) {
	//			putChar( *s );
	//			s++;
	//			}
	//		}
	//
	public block print uses proc {
		abs {
			s		=	s0;
			}
		code {
		public enter:
			lda		$sp,	-sav1($sp);
			stq		$ra,	savRet($sp);
			stq		$s0,	sav0($sp);
		body:
			mov		$a0,	$s;					//	Pointer to char in string
			{
			while:
				ldbu	$a0,	($s);			//	Get character
				beq		$a0,	end;			//	Break if at end of string
			do:
				bsr		Sys.putChar.enter;		//	Print char
				addq	$s,	1;					//	Increment pointer
				br		while;
			end:
			}
		return:
			ldq		$s0,	sav0($sp);
			ldq		$ra,	savRet($sp);
			lda		$sp,	+sav1($sp);
			ret;
			}
		}
	
	//	void error( char *s ) {
	//		print( s );
	//		exit( -1 );
	//
	
	public block error uses proc {
		code {
		public enter:
			lda		$sp,	-sav0($sp);
			stq		$ra,	savRet($sp);
		body:
			bsr		print.enter;
			negq	1,		$a0;
			bsr		Sys.exit.enter;
		return:
			ldq		$ra,	savRet($sp);
			lda		$sp,	+sav0($sp);
			ret;
			}
		}
	
	//	char *readLine( char *s, long max ) {
	//		register long i = 0;
	//		register long c;
	//		while ( TRUE ) {
	//			c = getchar();
	//			if ( c < 0 || c == '\n' )
	//				break;
	//			if ( i < max )
	//				s[ i ] = c;
	//			i++;
	//			}
	//		if ( i > max )
	//			i = max;
	//		s[ i ] = '\0';
	//		if ( c < 0 )
	//			return NULL;
	//		else
	//			return s + i;
	//		}
	//	
	public block readLine uses proc {
		abs {
			s		=	s0;
			max		=	s1;
			i		=	s2;
			c		=	s3;
			}
		code {
		public enter:
			lda		$sp,	-sav4($sp);
			stq		$ra,	savRet($sp);
			stq		$s0,	sav0($sp);
			stq		$s1,	sav1($sp);
			stq		$s2,	sav2($sp);
			stq		$s3,	sav3($sp);
		body:
			mov		$a0,	$s;							//	Pointer to character
			mov		$a1,	$max;						//	Size of input buffer
			clr		$i;									//	Count of characters read
			{
			while:
				bsr		Sys.getChar.enter;				//	Get a char
				mov		$v0,	$c;
				blt		$c,		end;
				cmpeq	$c,		'\n',	$t0;			//	Break if newline
				blbs	$t0,	end;
			do:
				{
				if:
					cmpult	$i,	$max,	$t0;			//	If within buffer
					blbc	$t0,	end;
				then:
					addq	$s,		$i,	$t0;			//	Store the character
					stb		$c,		($t0);
				end:
				}
				addq	$i,	1;							//	Increment count
				br	while;
			end:
			}
			{
			if:
				cmpule	$i,	$max,	$t0;				//	If not within buffer
				blbs	$t0,	end;
			then:
				mov		$max,	$i;
			end:
			}
			addq	$s,		$i,		$t0;
			stb		$zero,	($t0);						//	Append null char
			{
			if:
				bge		$c,		else;
			then:
				clr		$v0;
				br		end;
			else:
				mov		$t0,	$v0;
			end:
			}
		return:
			ldq		$s3,	sav3($sp);
			ldq		$s2,	sav2($sp);
			ldq		$s1,	sav1($sp);
			ldq		$s0,	sav0($sp);
			ldq		$ra,	savRet($sp);
			lda		$sp,	+sav4($sp);
			ret;
			}
		}

	//	#define LEFT	-1
	//	#define UNKNOWN	0
	//	#define RIGHT	+1
	//	void printf( char *s, long param0, long param1, long param2, long param3, long param4, ... ) {
	//		static long param[ 5 ];
	//		long *p = param;
	//		long defaultAlign;
	//		long alignment;
	//		char padChar;
	//		long fieldWidth;
	//		char *result;
	//		param[ 0 ] = param0;
	//		param[ 1 ] = param1;
	//		param[ 2 ] = param2;
	//		param[ 3 ] = param3;
	//		param[ 4 ] = param4;
	//		while ( *s != NULL ) {
	//			if ( *s == '%' ) {
	//				s++;
	//				if ( *s == '+' ) {
	//					alignment = RIGHT;
	//					s++;
	//					}
	//				else if ( *s == '-' ) {
	//					alignment = LEFT;
	//					s++;
	//					}
	//				else
	//					alignment = UNKNOWN;
	//				if ( *s =='0' )
	//					padChar = '0';
	//				else
	//					padChar = ' ';
	//				fieldWidth = 0;
	//				while ( '0' <= *s && *s <= '9' ) {
	//					fieldWidth = fieldWidth * 10 + *s - '0';
	//					s++;
	//					}
	//				switch ( *s ) {
	//					case 'b':
	//						result = Number.toUnsigned( *p++, 2 );
	//						defaultAlign = RIGHT;
	//						break;
	//					case 'o':
	//						result = Number.toUnsigned( *p++, 8 );
	//						defaultAlign = RIGHT;
	//						break;
	//					case 'd':
	//						result = Number.toSigned( *p++, 10 );
	//						defaultAlign = RIGHT;
	//						break;
	//					case 'x':
	//						result = Number.toUnsigned( *p++, 16 );
	//						defaultAlign = RIGHT;
	//						break;
	//					case 'c':
	//						result = String.fromChar( *p++ );
	//						defaultAlign = LEFT;
	//						break;
	//					case 's':
	//						result = *p++;
	//						defaultAlign = LEFT;
	//						break;
	//					default:
	//						result = String.fromChar( *s );
	//						defaultAlign = LEFT;
	//					}
	//				s++;
	//				if ( alignment == UNKNOWN )
	//					alignment = defaultAlign;
	//				if ( alignment == RIGHT )
	//					result = String.padLeft( result, padChar, fieldWidth );
	//				else
	//					result = String.padRight( result, padChar, fieldWidth );
	//				print( result );
	//				}
	//			else {
	//				IO.putChar( *s++ );
	//				}
	//			}
	//		}
		
	public block printf extends proc.sav6 uses proc {
		abs {
			LEFT		=	-1;
			UNKNOWN		=	0;
			RIGHT		=	+1;
			s			=	s0;
			p			=	s1;
			alignment	=	s2;
			fieldWidth	=	s3;
			result		=	s4;
			padChar		=	s5;
			}
		data {
				align	quad;
			param:
				quad	[ 5 ];
			}
		local {
			defaultAlign:
				quad;
			size:
			}
		code {
			public enter:
				lda		$sp,	-size($sp);
				stq		$ra,	savRet($sp);
				stq		$fp,	savFP($sp);
				stq		$s0,	sav0($sp);
				stq		$s1,	sav1($sp);
				stq		$s2,	sav2($sp);
				stq		$s3,	sav3($sp);
				stq		$s4,	sav4($sp);
				stq		$s5,	sav5($sp);
				mov		$sp,	$fp;
			decls:
				mov		$a0,	$s;
				ldiq	$p,		param;
				stq		$a1,	0($p);
				stq		$a2,	8($p);
				stq		$a3,	16($p);
				stq		$a4,	24($p);
				stq		$a5,	32($p);
			body:
				{
				while:
					ldbu	$t0,	($s);
					beq		$t0,	end;
				do:
					{
					if:
						cmpeq	$t0,	'%',	$t1;
						blbc	$t1,	else;
					then:
						addq	$s,		1;
						{
						if:
							ldbu	$t0,	($s);
							cmpeq	$t0,	'+',	$t1;
							blbs	$t1,	plus;
							cmpeq	$t0,	'-',	$t1;
							blbs	$t1,	minus;
							br		else;
						plus:
							ldiq	$alignment,	RIGHT;
							addq	$s,		1;
							br		end;
						minus:
							ldiq	$alignment,	LEFT;
							addq	$s,		1;
							br		end;
						else:
							ldiq	$alignment,	UNKNOWN;
						end:
						}
						{
						if:
							ldbu	$t0,	($s);
							cmpeq	$t0,	'0',	$t1;
							blbc	$t1,	else;
						then:
							mov		'0',	$padChar;
							addq	$s,		1;
							br		end;
						else:
							mov		' ',	$padChar;
						end:
						}
						{
						for:
							clr		$fieldWidth;
						while:
							ldbu	$t0,	($s);
							cmpult	$t0,	'0',	$t1;
							blbs	$t1,	end;
							cmpule	$t0,	'9',	$t1;
							blbc	$t1,	end;
						do:
							mulq	$fieldWidth,	10;
							addq	$fieldWidth,	$t0;
							subq	$fieldWidth,	'0';
						continue:
							addq	$s,		1;
							br		while;
						end:
						}
						ldbu	$t0,	($s);
						{
						switch:
							cmpeq	$t0,	'b',	$t1;
							blbs	$t1,	caseB;
							cmpeq	$t0,	'd',	$t1;
							blbs	$t1,	caseD;
							cmpeq	$t0,	'x',	$t1;
							blbs	$t1,	caseX;
							cmpeq	$t0,	'o',	$t1;
							blbs	$t1,	caseO;
							cmpeq	$t0,	'c',	$t1;
							blbs	$t1,	caseC;
							cmpeq	$t0,	's',	$t1;
							blbs	$t1,	caseS;
							br		default;
						caseB:
							ldq		$a0,	($p);
							addq	$p,		8;
							ldiq	$a1,	2;
							bsr		Number.toUnsigned.enter;
							mov		$v0,	$result;
							ldiq	$t0,	RIGHT;
							stq		$t0,	defaultAlign($fp);
							br		end;
						caseD:
							ldq		$a0,	($p);
							addq	$p,		8;
							ldiq	$a1,	10;
							bsr		Number.toSigned.enter;
							mov		$v0,	$result;
							ldiq	$t0,	RIGHT;
							stq		$t0,	defaultAlign($fp);
							br		end;
						caseX:
							ldq		$a0,	($p);
							addq	$p,		8;
							ldiq	$a1,	16;
							bsr		Number.toUnsigned.enter;
							mov		$v0,	$result;
							ldiq	$t0,	RIGHT;
							stq		$t0,	defaultAlign($fp);
							br		end;
						caseO:
							ldq		$a0,	($p);
							addq	$p,		8;
							ldiq	$a1,	8;
							bsr		Number.toUnsigned.enter;
							mov		$v0,	$result;
							ldiq	$t0,	RIGHT;
							stq		$t0,	defaultAlign($fp);
							br		end;
						caseC:
							ldq		$a0,	($p);
							addq	$p,		8;
							bsr		String.fromChar.enter;
							mov		$v0,	$result;
							ldiq	$t0,	LEFT;
							stq		$t0,	defaultAlign($fp);
							br		end;
						caseS:
							ldq		$result,	($p);
							addq	$p,		8;
							ldiq	$t0,	LEFT;
							stq		$t0,	defaultAlign($fp);
							br		end;
						default:
							ldbu	$a0,	($s);
							bsr		String.fromChar.enter;
							mov		$v0,	$result;
							ldiq	$t0,	LEFT;
							stq		$t0,	defaultAlign($fp);
						end:
						}
						addq	$s,		1;
						{
						if:
							cmpeq	$alignment,	UNKNOWN,	$t0;
							blbc	$t0,	end;
						then:
							ldq		$alignment,	defaultAlign($fp);
						end:
						}
						{
						if:
							cmpeq	$alignment,	RIGHT,	$t0;
							blbc	$t0,	else;
						then:
							mov		$result,	$a0;
							mov		$padChar,	$a1;
							mov		$fieldWidth,	$a2;
							bsr		String.padLeft.enter;
							br		end;
						else:
							mov		$result,	$a0;
							mov		$padChar,	$a1;
							mov		$fieldWidth,	$a2;
							bsr		String.padRight.enter;
						end:
						}
						mov		$v0,	$a0;
						bsr		IO.print.enter;
						br		end;
					else:
						ldbu	$a0,	($s);
						bsr		Sys.putChar.enter;
						addq	$s,		1;
					end:
					}
					br		while;
				end:
				}
			return:
				mov		$fp,	$sp;
				ldq		$s5,	sav5($sp);
				ldq		$s4,	sav4($sp);
				ldq		$s3,	sav3($sp);
				ldq		$s2,	sav2($sp);
				ldq		$s1,	sav1($sp);
				ldq		$s0,	sav0($sp);
				ldq		$fp,	savFP($sp);
				ldq		$ra,	savRet($sp);
				lda		$sp,	+size($sp);
				ret;
				}
		}
		
	}
